<?php


    header("Vary: User-Agent, Accept");

    $mobile_browser = 0;
    $display_mode_changed = false;


    //There's user's choice
    if (isset($_GET['mobile']) && in_array($_GET['mobile'], Array("0", "1"))) {
        // We have a VALUE directly FROM the user that we need TO store
        setcookie('m', $_GET['mobile'], TIME()+$cookie_lifetime);
        // Although we may already have a cookie, the VALUE may
        // have changed so we'll store it anyway. Also update $_COOKIE array.
        $_COOKIE['m'] = $_GET['mobile'];
        if ($_GET['m'] == "1") {
            $mobile_browser++;
            $display_mode_changed = true;
        } elseif (isset($_COOKIE['m']) && $_COOKIE['m'] == "1") {
            // If we have a cookie set to 1 or if we have
            // just set it to 1, we want the mobile view
            $mobile_browser++;
        }elseif (isset($_COOKIE['m']) && $_COOKIE['m'] == "0") {
            //forced Desktop View
            $mobile_browser = 0;
        }
    }

    //There's cookie
    if (isset($_COOKIE['m']) && $_COOKIE['m'] == "1"){
        // If we have a cookie set to 1 or if we have
        // just set it to 1, we want the mobile view
        $mobile_browser++;

    //There's device detection
    } else if(!isset($_COOKIE['m']) {
        // No indication of user preference
        include 'inc/Mobile_Detect.php';
        $detect = new Mobile_Detect();

        if ($detect->isMobile()) {
        // ANY mobile platform
           $mobile_browser=1;
        }else{
           $mobile_browser=0;
        }
    }

    if (!$display_mode_changed) {
        header("Cache-Control: max-age = " . $maxage);
        // Set cache control before we go any further
    } else {
        //force a quicker refresh of (only) the current page after
        //the visitor has changed the display mode manually:
        header("Expires: ".gmdate("D, d M Y H:i:s")." GMT"); // Always expired
        header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");// always modified
        header("Cache-Control: no-cache, must-revalidate, max-age = 0");// HTTP/1.1
        header("Pragma: nocache");// HTTP/1.0
        header("Cache-Control: max-age = 0"); //force refresh of this page
    }

?>



<!doctype html>

<html>
  <head>
  	<meta charset="utf-8" />
  	<title>Parliament buildings</title>
  	<meta name="viewport" content="width=device-width,initial-scale=1.0" />

  	<link rel="stylesheet" href="css/base.css" type="text/css" />
  	<link rel='stylesheet' href='css/enhanced.css' media='all and (min-width: 800px)' />

  	<!--[if lt IE 9 & !IEMobile]>
		<link rel="stylesheet" href="css/enhanced.css" />
	<![endif]-->

    <link rel = "canonical" href = "http://disruptivos.com/w3c/" />

  </head>

  <body>
  	<div id="main-container">

         <a href="index.php?mobile=<?php echo ($mobile_browser) ? '0' : '1'; ?>" class="switch-link">
            Switch to
            <?php echo ($mobile_browser) ? 'Desktop' : 'Mobile'; ?>
         </a>


  		<h1>Parliament buildings - Page 1</h1>

  		<article>
			<h2>Houses of Parliament in Canberra and Washington D.C.</h2>
			<section class="row">
				<aside>

					<?php echo ($mobile_browser) ? '<a href="images/Houses of Parliament Washington D.C..jpg">Click here to see the image</a>' : '<img src="images/Houses of Parliament Washington D.C..jpg" width="450" height="174" alt="Houses of Parliament Washington D.C." />'; ?>

					<p><span class="flag flag-usa">&nbsp;</span>The American Capitol seen from along the National Mall</p>
				</aside>
				<p>
					The Australian capital, Canberra, has much in common with the capital of the USA, Washington <abbr title="District of Columbia">D.C.</abbr> In both cases, the location was agreed as a compromise between two opposing interests: Sydney and Melbourne in the Australian case, Maryland and Virginia in the American one. Perhaps this is part of why the two cities have such a similar feel? They are both artificial constructs, built on land that would quite likely otherwise be largely uninhabited by humans.
				</p>
			</section>

			<section class="row">
				<aside>

					<?php echo ($mobile_browser) ? '<a href="images/The Old Parliament Building and the Australian War Memorial.jpg">Click here to see the image</a>' : '<img src="images/The Old Parliament Building and the Australian War Memorial.jpg" width="450" height="319" alt="The Old Parliament Building and the Australian War Memorial" />'; ?>

					<p><span class="flag flag-au">&nbsp;</span>The Old Parliament Building and beyond as seen from the Australian War Memorial, Canberra</p>
				</aside>
				<p>
					The most obvious comparison to draw is the layout of the cities, focussed on a central avenue with key buildings at either end. In Washington, the Capitol is at one end of the National Mall: a broad, grassed boulevard that stretches in a straight line from Capitol Hill at one end to the Washington Memorial at the other (with the Lincoln Memorial and others between).
				</p>

				<a href="page2.php">Read more...</a>
			</section>
		</article>
	</div>
  </body>
</html>
