<?php

/**
 * Mobile Detect
 *
 * @license    http://www.opensource.org/licenses/mit-license.php The MIT License
 * @version    SVN: $Id: Mobile_Detect.php,v 1.1 2011/07/06 14:40:34 phila Exp $
 */

class Mobile_Detect {

	var $accept;
	var $userAgent;

	var $isMobile     = false;
	var $isAndroid    = null;
	var $isBlackberry = null;
	var $isIphone = null;
	var $isOpera      = null;
	var $isPalm       = null;
	var $isWindows    = null;
	var $isGeneric    = null;

	var $devices = array(
		"android"       => "android",
		"blackberry"    => "blackberry",
		"iphone"        => "(iphone|ipod)",
		"opera"         => "opera mini",
		"palm"          => "(avantgo|blazer|elaine|hiptop|palm|plucker|xiino)",
		"windows"       => "windows ce; (iemobile|ppc|smartphone)",
		"generic"       => "(kindle|mobile|mmp|midp|o2|pda|pocket|psp|symbian|smartphone|treo|up.browser|up.link|vodafone|wap)"
	);


	function __construct() {
		$this->userAgent = $_SERVER['HTTP_USER_AGENT'];
		$this->accept    = $_SERVER['HTTP_ACCEPT'];

		if (isset($_SERVER['HTTP_X_WAP_PROFILE'])|| isset($_SERVER['HTTP_PROFILE'])) {
			$this->isMobile = true;
		} elseif (strpos($this->accept,'text/vnd.wap.wml') > 0 || strpos($this->accept,'application/vnd.wap.xhtml+xml') > 0) {
			$this->isMobile = true;
		} else {
			foreach ($this->devices as $device => $regexp) {
				if ($this->isDevice($device)) {
					$this->isMobile = true;
				}
			}
		}
	}


	/**
	 * Overloads isAndroid() | isBlackberry() | isOpera() | isPalm() | isWindows() | isGeneric() through isDevice()
	 *
	 * @param string $name
	 * @param array $arguments
	 * @return bool
	 */
	function __call($name, $arguments) {
		$device = substr($name, 2);
		if ($name == "is" . ucfirst($device)) {
			return $this->isDevice($device);
		} else {
			trigger_error("Method $name not defined", E_USER_ERROR);
		}
	}


	/**
	 * Returns true if any type of mobile device detected, including special ones
	 * @return bool
	 */
	function isMobile() {
		return ($this->isMobile) ? 1 : 0;
	}


	function isDevice($device) {
		$var    = "is" . ucfirst($device);
		$return = $this->$var === null ? (bool) preg_match("/" . $this->devices[$device] . "/i", $this->userAgent) : $this->$var;

		if ($device != 'generic' && $return == true) {
			$this->isGeneric = false;
		}

		return $return;
	}
}
