<?php


    header("Vary: User-Agent, Accept");

    $cookie_lifetime = 3600 * 24 * 31;
    $mobile_browser = 0;
    $display_mode_changed = false;


    //There's user's choice
    if (isset($_GET['mobile']) && in_array($_GET['mobile'], Array("0", "1"))) {
        // We have a VALUE directly FROM the user that we need TO store
        setcookie('m', $_GET['mobile'], TIME()+$cookie_lifetime);
        // Although we may already have a cookie, the VALUE may
        // have changed so we'll store it anyway. Also update $_COOKIE array.
        $_COOKIE['m'] = $_GET['mobile'];
        if ($_GET['m'] == "1") {
            $mobile_browser++;
            $display_mode_changed = true;
        } elseif (isset($_COOKIE['m']) && $_COOKIE['m'] == "1") {
            // If we have a cookie set to 1 or if we have
            // just set it to 1, we want the mobile view
            $mobile_browser++;
        }elseif (isset($_COOKIE['m']) && $_COOKIE['m'] == "0") {
            //forced Desktop View
            $mobile_browser = 0;
        }
    }

    //There's cookie
    if (isset($_COOKIE['m']) && $_COOKIE['m'] == "1"){
        // If we have a cookie set to 1 or if we have
        // just set it to 1, we want the mobile view
        $mobile_browser++;

    //There's device detection
    } else if(!isset($_COOKIE['m']) {
        // No indication of user preference
        include 'inc/Mobile_Detect.php';
        $detect = new Mobile_Detect();

        if ($detect->isMobile()) {
        // ANY mobile platform
           $mobile_browser=1;
        }else{
           $mobile_browser=0;
        }
    }

    if (!$display_mode_changed) {
        header("Cache-Control: max-age = " . $maxage);
        // Set cache control before we go any further
    } else {
        //force a quicker refresh of (only) the current page after
        //the visitor has changed the display mode manually:
        header("Expires: ".gmdate("D, d M Y H:i:s")." GMT"); // Always expired
        header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");// always modified
        header("Cache-Control: no-cache, must-revalidate, max-age = 0");// HTTP/1.1
        header("Pragma: nocache");// HTTP/1.0
        header("Cache-Control: max-age = 0"); //force refresh of this page
    }

?>

<!doctype html>

<html>
  <head>
  	<meta charset="utf-8" />
  	<title>Parliament buildings</title>
  	<meta name="viewport" content="width=device-width,initial-scale=1.0" />

  	<link rel="stylesheet" href="css/base.css" type="text/css" />
  	<link rel='stylesheet' href='css/enhanced.css' media='all and (min-width: 800px)' />

  	<!--[if lt IE 9 & !IEMobile]>
		<link rel="stylesheet" href="css/enhanced.css" />
	<![endif]-->

  	<link rel="canonical" href="http://www.disruptivos.com/w3c/index.php"/>
  </head>

  <body>
  	<div id="main-container">

        <a href="index.php?mobile=<?php echo ($mobile_browser) ? '0' : '1'; ?>" class="switch-link">
            Switch to
            <?php echo ($mobile_browser) ? 'Desktop' : 'Mobile'; ?>
         </a>

  		<h1>Parliament buildings - Page 2</h1>

			<section class="row">
				<aside>
					<?php echo ($mobile_browser) ? '<a href="images/Front of Parliament House Canberra.jpg">Click here to see the image</a>' : '<img src="images/Front of Parliament House Canberra.jpg" width="400" height="216" alt="Houses of Parliament Washington D.C." />'; ?>
					<p><span class="flag flag-au">&nbsp;</span>View of the front of Parliament House, Canberra</p>
				</aside>
				<p>
					In Canberra, a much longer boulevard stretches from Parliament House at the top of Capital Hill to the Australian War Memorial. Unlike Washington, the Australian War Memorial is itself on a hill (Mt. Ainslie) and the boulevard is interrupted by a lake (Lake Burley Griffin). Furthermore, the modern day Parliament House in Canberra is very young, having been built as recently as 1988 (work began on the American Capitol in the late 18th century).
				</p>
			</section>

			<section class="row">
				<aside>
					<?php echo ($mobile_browser) ? '<a href="images/Front of Old Parliament House Canberra.jpg">Click here to see the image</a>' : '<img src="images/Front of Old Parliament House Canberra.jpg" width="400" height="213" alt="Houses of Parliament Washington D.C." />'; ?>

					<p><span class="flag flag-au">&nbsp;</span>View of the front of Old Parliament House, Canberra.</p>
				</aside>
				<p>
					Canberra's Old Parliament building is closer to the lake but is exactly in line with the modern Parliament House and War Memorial.
				</p>
			</section>

			<section class="row">
				<aside>

					<?php echo ($mobile_browser) ? '<a href="images/Palace of Westminster and Parliament building Eeichstag.jpg">Click here to see the image</a>' : '<img src="images/Palace of Westminster and Parliament building Eeichstag.jpg" width="566" height="200" alt="Houses of Parliament Washington D.C." />'; ?>

					<p>
						<span class="flag flag-ger">&nbsp;</span>
						<span class="flag flag-uk">&nbsp;</span>
						The British and German parliaments, surrounded by roads and other buildings. <br />
						Image sources: Palace of Westminster  <a href="http://www.bbc.co.uk/radio4/womanshour/01/media/palace-of-westminster.jpg">BBC</a>, Reichstag <a href="http://media-cdn.tripadvisor.com/media/photo-s/00/18/bd/9a/parliament-building-reichstag.jpg">Trip Advisor</a>.
					</p>
				</aside>
				<p>
					For many people from older countries, the idea of a planning to build a capital city from scratch, complete with boulevards stretching between important landmarks that are perfectly aligned with the compass, seems odd. Parliament buildings in places like London and Berlin are where they are because that's where the previous building was. And the one before that. And everything else will just jolly well have to fit around it! The German parliament building, the Reichstag, does have a boulevard stretching before it but Berlin does not have the same "obviously planned" layout as Canberra and Washington D.C.
				</p>

				<a href="index.php">Return to index</a>
			</section>
		</article>
	</div>
  </body>
</html>